# parent class used to specify mapper interface
class Mapper(object):
    # intializes the mapper
    # index map is a dictionary
    # return type: self
    def __init__(self, num_bits,indexMap):
        self.num_bits = num_bits
        self.indexMap = indexMap
        self.checkMapping()

    def checkMapping(self):
        problemDetected = False
        # check that all bits in the state are used
        for bit_idx in range(0,self.num_bits):
            if bit_idx not in self.indexMap.values():
                problemDetected = True
                print "MAPPING STATE ERROR: bit", bit_idx,"is not assigned"
        # check that there aren't extra bits
        if self.num_bits != len(set(self.indexMap.values())):
                problemDetected = True
                print "MAPPING STATE ERROR: too many bits assigned"
        # check that every switch in the array is assiged a bit
        for tile_x in range(-2,3,1):
            for tile_y in range(-2,3,1):
                tile_coords = (tile_x, tile_y)
                for sheet_orientation in ['e','h']:
                    for x_row in range(4):
                        for x_col in range(3):
                            switch_coordinates = self.getMappingCoordinates(tile_coords,sheet_orientation,'x',x_row,x_col)
                            if switch_coordinates not in self.indexMap.keys():
                                problemDetected = True
                                print tile_coords, sheet_orientation
                                print "MAPPING SWITCH ERROR: switch", switch_coordinates,"is not assigned"
                    for y_row in range(3):
                        for y_col in range(4):
                            switch_coordinates = self.getMappingCoordinates(tile_coords,sheet_orientation,'y',y_row,y_col)
                            if switch_coordinates not in self.indexMap.keys():
                                problemDetected = True
                                print "MAPPING SWITCH ERROR: switch", switch_coordinates,"is not assigned"
        # check that assigned switch coorinate is valid
        # (Even number of sheet steps is either within a TILE or an EMPTY SPACE)
        # (Even number of switch steps is either within a CONDUCTOR or an EMPTY SPACE)
        for switch_coordinate in self.indexMap.keys():
            sheet_x = switch_coordinate[0]
            sheet_y = switch_coordinate[1]
            switch_x = switch_coordinate[2]
            switch_y = switch_coordinate[3]
            sheet_steps = abs(sheet_x) + abs(sheet_y)
            switch_steps = abs(switch_x) + abs(switch_y)
            if (sheet_steps%2) == 0:
                problemDetected = True
                print "COORINATE ERROR: switch", switch_coordinates,"is NOT a valid coordinate"
            if (switch_steps%2) == 0:
                problemDetected = True
                print "COORINATE ERROR: switch", switch_coordinates,"is NOT a valid coordinate"
        if problemDetected:
            raise Exception("MAPPING ERROR: See print out for details")

    def getMappingCoordinates(self, tile_coordinates, sheet_orientation, switch_orientation, row,col):
        tile_x, tile_y = tile_coordinates
        # convert to 2x scale to acount for gaps
        sheet_x = 2*tile_x
        sheet_y = 2*tile_y
        # E plane sheets are located to the right of the tile
        if sheet_orientation == 'e':
            sheet_x = sheet_x - 1
        # H plane sheets are located below the tile
        if sheet_orientation == 'h':
            sheet_y = sheet_y - 1
        switch_x = 0
        swirch_y = 0
        if switch_orientation == 'x':
            switch_x = -2 + 2*col
            switch_y = 3 - 2*row
        if switch_orientation == 'y':
            switch_x = -3 + 2*col
            switch_y = 2 - 2*row
        switch_coordinates = (sheet_x,sheet_y,switch_x,switch_y)
        return switch_coordinates

    # Returns which bit index determines the status of the specified switch
    def getStateBitIdx(self, tile_coordinates, sheet_orientation, switch_orientation, row,col):
        switch_coordinates = self.getMappingCoordinates(tile_coordinates, sheet_orientation, switch_orientation, row,col)
        return self.indexMap[switch_coordinates]
